<?php
defined('BASEPATH') or exit('No direct script access allowed');

class User_model extends CI_Model
{
	public $table = 'm_user';
	public $id = 'id_user';
	public $kode = 'user_name';
	public $variable = 'user';
	public $user_perusahaan = 'm_user_perusahaan';

	function __construct()
	{
		parent::__construct();
	}

	public function getAll($data)
	{
		$this->db->join($this->user_perusahaan . " as b ", 'a.id_user= b.id_user', 'inner');
		return $this->db->get_where($this->table . " as a", $data);
	}

	public function getKode($kode_input)
	{
		$data = array();
		$this->db->select('*');
		$this->db->where($this->kode, $kode_input);
		$Q = $this->db->get($this->table);

		if ($Q->num_rows() > 0) {
			$data = $Q->row_array();
		}

		$Q->free_result();
		return $data;
	}

	public function getId($id)
	{
		$data = array();
		$this->db->select('*');
		$this->db->where($this->id, $id);
		$Q = $this->db->get($this->table);

		if ($Q->num_rows() > 0) {
			$data = $Q->row_array();
		}

		$Q->free_result();
		return $data;
	}

	// public function selectAkses($id) {
	// 	$data = array();
	//        $this->db->select('*');
	//        $this->db->join('m_controller', 'm_controller.id_controller = m_user_akses.id_controller', 'LEFT');
	//        $this->db->where('m_user_akses.id_user', $id);
	//        $Q = $this->db->get('m_user_akses');

	//        if($Q->num_rows()>0){
	//            foreach ($Q->result_array() as $row) {
	//                $data[] = $row;
	//            }
	//        }

	//        $Q->free_result();
	//        return $data;
	// }

	function getIdMax()
	{
		$this->db->select_max('id_' . $this->variable);
		return $this->db->get($this->table);
	}

	function insertData($data)
	{
		return $this->db->insert($this->table, $data);
	}

	function updateData($id, $object)
	{
		$this->db->where('id_' . $this->variable, $id);
		return $this->db->update($this->table, $object);
	}

	function deleteData($id_rumah)
	{
		$this->db->where('id_' . $this->variable, $id_rumah);
		$this->db->delete($this->table);
	}

	function insertUserPerusahaan($object)
	{
		return $this->db->insert($this->user_perusahaan, $object);
	}
}
